<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Poinbelanja extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'member_id',
        'kodetran',
        'jml_poin',
        'sts_poin',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function member(): BelongsTo
    {
        return $this->belongsTo(Member::class);
    }

    public function scopePencarian(Builder $query): void
    {
        $query->whereHas('member', function ($query) {
            $query->where('nm_member', 'like', '%' .  request('cari') . '%');
        })->whereHas('user', function ($query) {
            $query->where('nm_user', 'like', '%' .  request('cari') . '%');
        });
    }
}
